#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Frog eggsMod01.fsh   by   zero2021 
//https://www.shadertoy.com/view/slfGR4
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.1415926535897932384626

vec2 grid_random(vec2 p) {
  return fract(sin(vec2(dot(p, vec2(127.1, 311.7)), dot(p, vec2(269.5, 183.3)))) * 43758.5453);
}
  
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = fragCoord/iResolution.xy;
    
    vec2 mn = iResolution.xy / 40.0;

    vec4 _o = vec4(0.0, 0.0, 0.0, 1.0);

    float scale = 0.4;
    for(int l = 0; l < 8; l++){
      vec2 _uv = uv;
      float rad = iTime * scale * 0.1;
      _uv.x += cos(rad);
      _uv.y += sin(rad);
      _uv *= mn / scale;
      vec2 i = floor(_uv);
      vec2 f = fract(_uv);

      float m_dist = 1.0;
      vec2 m_point;
      for (float j = -1.0; j <= 1.0; j++) {
        for(float k = -1.0; k <= 1.0; k++) {
          vec2 neighbor = vec2(k, j);
          vec2 point = grid_random(i + neighbor);
          point = 0.5 + 0.5 * sin(iTime + point * PI * 2.0);
          float dist = distance(neighbor + point, f);
          if (dist < m_dist) {
            m_dist = dist;
            m_point = point;
          }
        }
      }
      m_dist = 1.0 - m_dist;
      float value = (smoothstep(0.65, 0.7, m_dist) - smoothstep(0.75, 0.8, m_dist)) * 0.3;
      value += smoothstep(0.85, 0.9, m_dist);
      _o.xyz = mix(_o.xyz, vec3(scale, scale, scale), value);
      scale *= 1.1;
    }

    // Output to screen
    fragColor = _o;

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

